/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <csl_chip.h>
#include "swi.h"

void
swiSysMode(void)
{
    asm(" mrs r0, spsr");
    asm(" orr  r0, r0, #0x1f ; SYS mode");
    asm(" msr spsr, r0");
}

int
SWI_dispatcher(int serviceNum, int arg0, int arg1, int arg2)
{
    /* printf("SWI #0x%.8X\n", serviceNum); */
    switch (serviceNum)
    {
    case SWI_SYSMODE:
        swiSysMode();
        break;
    case SWI_READSPSR:
        return CSL_chipReadReg(CSL_CHIP_REG_SPSR);
    case SWI_WRITESPSR:
        return CSL_chipWriteReg(CSL_CHIP_REG_SPSR, arg0);
    default:
        break;
    }
    return -1;
}
